# Projet Ésisar 3A : Émulateur RISC-V

⚠️ *Ce symbole dénote les TODO.*

## Présentation du projet

Philosophie par rapport au projet MIPS et à la version 2023-2024 du projet RISC-V (stockée dans `/Archives`) :

* Plus guidé pour éviter les détours coûteux et bien exploiter les séances.
* 3 sujets de la forme : exercices préparatoires à faire en début de TP (donc la solution se colle quasi-verbatim dans le code du projet), fin de session + travail perso pour intégrer et faire la glue.
* Pas d'assemblage grande échelle à la main (donc on compare avec une référence données par la chaine clang).

**Contenus attendus dans le projet**

Architecture :

* Registres : `x0` à `x31` plus leurs noms "jolis"
  - On ne fait que du calcul sur des entiers signés de 64 bits
* Instructions (subset RV64I : 13 côté assembleur, 10 côté émulateur) :
  - `addi`, `add`, `sub`, `li` (alias de `addi`), `mv` (alias de `addi`)
  - `beq`, `bne`, `blt`, `bge`, `jal`, `j` (alias `jal`)
  - `lw`, `sw`
* Mémoire : standardisée et attendue par le sujet
  - Tout le monde ne comprend pas bien la mémoire, c'est une bonne façon de travailler la notion.
  - La plage d'adresses est 0...16384 ; le code est chargé à 0, le pointeur de pile est initialisé à 16384. (Note : on ne fait pas de vraies fonctions.)
  - La boucle fetch-decode-execute devra utiliser la mémoire (évitant aussi les écueils de relecture du fichier assembleur).

Tâches à accomplir :

* Assembleur : doit lire les instructions sous forme de texte, les encoder, et produire du texte hexadécimal.
* Émulateur : doit charger le texte hexadécimal en mémoire et exécuter le programme.

## Organisation des fichiers

`Makefile`: **Génération des archives à donner aux étudiants**

`Chamilo/` : **Fichiers à uploader sur Chamilo**

Ce dossier entier est généré en lançant la commande `make` dans `ProjetRISCV`. Il contient les fichiers à uploader sur Chamilo.

Les dossiers `TP1`, `TP2` et `TP3` ne sont pas à uploader (ils sont déjà archivés dans les `.zip`).

`Docs/` : **Sources du fichier de documentation RISC-V fourni aux éudiants**

La documentation RISC-V officielle est un peu dure à lire et pas ultra bien organisée. On fournit notre propre document très simplifié.

`Divers/` : **Fichiers non-classés**

Notamment des petits fichiers pour les étudiants, qui sont copiés dans `Chamilo/` quand on génére le code étudiant.

`Sujet/` : **Sources du fichier sujet avec les consignes du projet**

Se compile avec pandoc.

`Vprof/` : **Implémentation prof. de référence**

Fait exactement ce qui est attendu des étudiants, avec une organisation idéale, mais sans utiliser de techniques exotiques.

Des tests unitaires relativement exhaustifs sont inclus et sont mobilisés dans le système de correction automatique.

⚠️ Il s'agit du code de 2023-2024 qui, pour l'assembleur, n'utilise pas _exactement_ les fonctions telles qu'écrites dans les exercices de cette année. Les différences sont mineures. L'émulateur est identique à la version étudiante.

## Planification des rendus

En 2024-2025, il y a 3 séances.

- Rendu de test à la 1ère séance, pour vérifier que tout va bien.
- Rendu #1 après la première séance → correction de l'assembleur.
- Rendu #2 après la deuxième → intermédiaire, vérifier que ça avance bien au cas par cas.
- Rendu #3 après la troisième → correction de l'émulateur.

## Instructions d'animation de la première séance

Le timing est important, donc faire attention !

1. Passer les slides d'introduction. Il n'y a quasiment aucune info scientifique dedans parce que ça c'est dans le sujet. À la place c'est juste une overview des dates et des rendus, plus le point super important que c'est Chamilo qui a toujours raison : le sujet à jour il est là-bas, et en cas de conflit de rendus c'est Chamilo qui gagne.
2. Les étudiants téléchargent l'archive du TP et lisent le sujet.
3. Au début on ne se préoccupe pas du projet dans le dossier `assembleur/`, on fait juste les exos, avec correction au tableau. Il est important que l'encadrant·e rythme pour qu'on arrive au rendu de test dans les temps.
4. Environ 45 minutes avant la fin, il faut conclure les exercices (quitte à laisser les étudiants finir plus tard) et faire le rendu de test. Les étudiants doivent "prendre en main" le dossier `assembleur/` (juste compiler et lancer les tests, qui à ce stade se plaignent que le fichier hexa ne contient aucune instruction) et rendre ça sur Chamilo.
5. Vérifier que tous les rendus sont là et passent *pendant la séance* (pour rapporter les problèmes immédiatement).
6. Laisser les étudiants prendre en main le code, finir les exercices si besoin, et commencer à intégrer les solutions dans le programme du dossier `assembler/`. L'assembleur est à rendre avant la prochaine séance.

Quelques intuitions générales aussi :
- Forcer les étudiants à visualiser leurs problèmes. S'ils ne comprennent pas ce qu'il se passe, faire ajouter des `printf()`. Le debugger est hors-sujet pour ce cours.

## Instructions de correction des rendus

1. Télécharger l'archive du groupe sur Chamilo en allant dans la liste des travaux et en sélectionnant "Télécharger tous les travaux".
2. La mettre dans le sous-dossier `Corrections` de l'année et lancer `untar.py` pour décompresser les projets. Chaque projet apparaît avec comme nom l'ID de l'utilisateur qui l'a soumis, qui sert d'index dans le tableur.
   ```bash
   % ./untar.py Project-RISC-V-rendu-de-test-Groupe-3.zip
   ```
   **Attention**, s'il y a des rendus non conformes (e.g. des archives `.zip` ou autres anomalies), ils seront ignorés : s'il semble manquer des soumissions, vérifier si elles ne sont pas sur Chamilo sous un format à la noix.
3. Ouvrir le fichier `notes-*.ods` de l'année (dans LibreOffice Calc) pour pouvoir y saisir les notes et commentaires.
4. Pour chaque projet rendu, aller dans le dossier du rendu puis :
   - Compiler : `make`
   - Lancer les tests des étudiants : `make test`
   - (Rendu assembleur et émulateur) Lancer nos tests simples (alias suggéré) : `TEST_FILES=../../../../Vprof/tests/*/*.s python test.py`
   - (Rendu assembleur et émulateur) Lancer nos tests avancés (alias suggéré) : `TEST_FILES=../../../../Vprof/tests-advanced/*/*.s python test.py`
   - Voir les instructions détaillées par rendu ci-dessous.
5. Une fois les notes attribuées et les commentaires écrits, lancer `gen_feedback.py` qui extrait le tableur vers des fichiers texte dans le dossier `Feedback-Rendu*`.
6. Sur Chamilo, coller en commentaire de chaque soumission les contenus du fichier de feebdack associé. Bien cocher la case "Envoyer par mail à l'étudiant" pour que le groupe soit notifié.

Les rendus sont indexés sur le dépôt Git ; pousser les fichiers des étudiants ainsi que les fichiers de feedback en même temps que le tableur. `.gitignore` est préconfiguré donc il devrait suffire de `git add Corrections-23-24`.

Détails pour chaque rendu.

**Rendu de test**

Vérifier :
- Que le nom des étudiants est bien donné dans le Makefile
- Que le README est rempli
- Que ça compile
- Que `make test` fait ce qui est prévu ("Output should contain 3 instructions, but has 0")

**Rendu 1**

Rapporter les warnings qui révèlent un comportement incorrect (e.g. cast entier/pointeur) mais ignorer ceux qui n'ont pas d'effet immédiat (e.g. paramètre non utilisé).

Dans la sortie de `make test` et des tests de correction, repérer s'il y a des crashs (message d'erreur du type `exit code 11`, pour rappel 11 c'est SIGSEGV soit segfault, 5 c'est SIGTRAP soit habituellement stack smashing = gros dépassement de tableau variable locale). Il est relativement courant que des bugs observés sur nos machines de correcteurs ne soient pas visibles sur les machines des étudiants. Essayer, dans un budget limité (idée : 10 minutes) de corriger ces crashs, et remonter les explications en cas de succès.

Barème : on est gentils dans l'ensemble. Les attendus ne sont pas les mêmes pour les groupes qui ont eu du mal tout le semestre que pour les ex-2A bien à l'aise.

- Tests simples : noter la proportion de tests de correction qui passent, sur 5. C'est la majeure partie de la note du rendu. 5/5 si tout passe, à la proportionnelle sinon. On ne met pas de points sur les tests avancés, mais on fait un retour sur ce qui ne marche pas s'il y en a (pour les étudiants à l'aise pour qui les tests simples ne sont pas un problème).
- Tests fournis : noter sur 5 la qualité des tests fournis. Le fait de les passer compte dans cette catégorie mais pas beaucoup, parce qu'on a déjà les nôtres dans la catégorie précédente. Noter surtout l'exhaustivité des (1) instructions testées, (2) registres nommés via les xN et les alias, (3) opérandes positives, négatives, et grandes valeurs. Bonus si la syntaxe est testée en profondeur (espacements en début/milieu/fin de ligne, etc).
- README.md : il n'y a pas de bonne/mauvaise réponse, par design. Donner des points si les étudiants se sont posé des questions de fond ou ont eu un raisonnement rigoureux, enlever des points si les réponses sont génériques/vagues.
- Erreur compil : saisir 1 si l'assembleur ne compilait pas.
- Inutilisable : saisir 1 si le code plante systématiquement ou quasi-systématiquement et que vous n'avez pas pu le ramener à un produit raisonnable dans le budget de correction.
- Qualité code : ce champ est un bonus/malus : commencer à 2.5. Rajouter des points s'il y a un découpage clair en fonctions, en fichiers, des commentaires, un passage rapide du texte aux entiers, etc. Enlever des points s'il y a un énorme main(), qu'il y a encore des chaînes de caractères dans les fonctions d'encodage des instructions, des globales, etc.
- Retard : nombre de jours de retard.

En cas de très gros plantage ou pas d'assembleur du tout (i.e. binômes à l'Ouest), évaluer en détail le code qui est fourni et noter sur l'effort en séance et la qualité de ce qui est fait. On n'hésitera pas à mettre e.g. 4/5 dès que les exos faits sont bien compris. De notre côté (conception de sujet), le TP2/TP3 combiné n'a que la moitié d'obligatoire pour permettre aux étudiants en difficulté d'en faire moins et de le répartir sur deux séances. Garder un oeil dessus. (Il est acceptable de ne faire que les exos si vraiment ça ne passe pas.)

**Rendu 2**

Ce rendu intermédiaire a un coefficient très faible (du genre 1/3 ou 1/4 des autres rendus) et a juste pour but de vérifier que le projet avance et que les étudiants bossent. La façon de noter dépend de si le binôme est considéré « débutant ou non » :

- Pour les binômes débutants, le seul critère dur est qu'il faut enlever des points si le code no compile pas. Pour le reste, mettre une note à la main sur 5 qui reflète les efforts faits en salle de TP et en autonomie et les progrès par rapport au premier rendu. A priori ils n'auront rendu que les exercices, et peut-être pas tous. Aviser au cas-par-cas.

- Pour les binômes expérimentés, au rendu 2 ils doivent en être entre le tout début de la partie 4 et la toute fin de la partie 4 pour être dans les temps. Penser à signaler les binômes qui sont "en retard". Pas de barème dur, mais :
  - Enlever des points si le code ne compile pas.
  - Insister sur le besoin d'écrire des tests s'il n'y a pas de tests.
  - Pour le reste, aviser.

Sur ce rendu, le feedback est plus important que la note. Mettre une note sur 5 manuellement et bien détailler le feedback.

**Rendu 3**

Même procédure que pour le rendu 1.

S'il y a des gens au rendu 3 qui ont tenté des fonctionnalités en plus (e.g. optimisation particulière, ajout de nouvelles instructions, etc) récompenser la curiosité intellectuelle. S'il y a un port de DOOM qui marche (et que le code n'est pas plagié) mettre 5/5 plus ou moins automatiquement.
